#include "TestLog.hpp"
#include "debug/TraceLog.hpp"
#include <cstdio>

namespace twitch {
namespace test {
TestLog::TestLog(Log::Level level)
    : m_level(level)
{
}

void TestLog::log(Level level, const char* format, va_list args) const
{
    if (level >= m_level) {
        TraceLog::get().log(level, format, args);
    }
}

void TestLog::setLevel(Level level)
{
    m_level = level;
}
}
}
