#pragma once

#include "playercore/platform/Platform.hpp"
#include "TestCase.hpp"
#include "TestLog.hpp"
#include <queue>
#include <string>
#include <vector>

namespace twitch {
namespace test {
class TestRunner : public TestCase::Listener {
public:
    class Listener {
    public:
        Listener() = default;
        virtual ~Listener() = default;
        virtual void onTestRunStart() = 0;
        virtual void onTestRunEnd(bool success) = 0;
    };

    TestRunner(Listener& listener);
    ~TestRunner() override = default;
    void addTest(const std::shared_ptr<TestCase>& test);
    void run();
    void cancel();
    void onTestCaseStart(const std::string& name) override;
    void onTestCaseEnd(const std::string& name, bool success) override;

private:
    Listener& m_listener;
    bool m_running;
    bool m_cancelled;
    bool m_success;
    std::vector<std::shared_ptr<TestCase>> m_testCases;
    std::queue<std::shared_ptr<TestCase>> m_queue;
    TestLog m_log;
};
}
}
