// NOTE: Tests will be run as part of the test runner by including its header file here
//      (for more details: http://stackoverflow.com/a/31089321/6933823)
#if defined(PS4) || defined(UWP) // Decode/Render tests not supported on non consoles
#include "async_player_test.hpp"
#endif

#include "player_analytics_event_test.hpp"
#include "player_metadata_test.hpp"
#include "player_quality_test.hpp"
#include "player_state_test.hpp"
#include "player_timed_test.hpp"
#include "playercore/MediaTime.hpp"

#include "IntegrationTest.hpp"
#include "gtestenv.hpp"
#include "debug/TraceLog.hpp"
#include "twitch/TwitchLink.hpp"

#include "optionparser.hpp"
#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <gtest/gtest.h>
#include <iostream>

namespace twitch {
IntegrationTestEnvironment* IntegrationTestEnvironment::create(const TestOptions& options)
{
    IntegrationTestEnvironment::TestInputData input;
    input.url = options.getUrl();

    // Make sure the tests know if the content we're testing is Live or VOD
    if (options.getStreamType() == TestOptions::StreamType::Unknown) {
        if ( !TwitchLink::isUsherUrl(input.url) ) {
            auto link = TwitchLink(input.url);
            if (link.getId().empty()) {
                std::cerr << "Only Twitch URLs supported for now" << std::endl;
                assert(false);
                return nullptr;
            }

            input.isLive = link.getContentType() == TwitchLink::ContentType::Live;
        } else {
            // For Usher URLs we assume live=true
            input.isLive = true;
        }
    } else {
        input.isLive = options.getStreamType() == TestOptions::StreamType::Live;
    }

    return new IntegrationTestEnvironment(options, input);
}

IntegrationTestEnvironment::IntegrationTestEnvironment(const TestOptions& options, const TestInputData& input)
    : m_options(options)
    , m_testInputData(input)
{
    TraceLog::get().setLevel(options.getLogLevel());
}

IntegrationTestEnvironment* IntegrationTest::environment = nullptr;

bool IntegrationTest::initialize(int argc, char** argv)
{
    testing::InitGoogleTest(&argc, argv);

    TestOptions options;
    // Temp - Currently if you pass arguments to GoogleTest, they will also be parsed internally by our command-line and it will
    // confuse it. Change the parse line to make it works until we figure it out.
    //options.parse(0, (char**)nullptr);
    if (!options.parse(argc, argv)) {
        return false;
    }

    environment = IntegrationTestEnvironment::create(options);
    if (!environment) {
        return false;
    }

    AddGlobalTestEnvironment(environment);
    AddGlobalTestEnvironment(GTestEnvironment::current);
    return true;
}

int IntegrationTest::run()
{
    if (environment == nullptr) {
        std::cerr << "Integration Test environment has not been initialized" << std::endl;
        return EXIT_FAILURE;
    }

    int code = RUN_ALL_TESTS();
    if (code != EXIT_SUCCESS) {
        std::cerr << "Integration Test failed with code: " << code << std::endl;
    }

    // new test runner
    // TODO add tests and return success/failure
    class : public test::TestRunner::Listener {
        void onTestRunStart() override
        {
        }

        void onTestRunEnd(bool success) override
        {
            (void) success;
        }
    } testListener;

    test::TestRunner runner(testListener);
    runner.run();

    return code;
}

}
