#pragma once
#include "TestOptions.hpp"
#include "playercore/Log.hpp"
#include "test/framework/TestRunner.hpp"
#include <gtest/gtest.h>
#include <string>

namespace twitch {
// Player Test Environment to add to GoogleTests
// For more info: https://github.com/google/googletest/blob/master/googletest/docs/AdvancedGuide.md#global-set-up-and-tear-down
class IntegrationTestEnvironment : public testing::Environment {
public:
    // Describes input data to run the tests against
    struct TestInputData {
        std::string url;
        bool isLive;
    };

    static IntegrationTestEnvironment* create(const TestOptions& options);

    ~IntegrationTestEnvironment() override = default;

    const TestOptions& options() const { return m_options; }
    const TestInputData& testData() const { return m_testInputData; }

protected:
    // Override this to define how to set up the environment
    void SetUp() override {}

    // Override this to define how to tear down the environment.
    void TearDown() override {}

protected:
    IntegrationTestEnvironment(const TestOptions& options, const TestInputData& input);

    TestOptions m_options;
    TestInputData m_testInputData;
};

class IntegrationTest  {
public:
    static bool initialize(int argc, char** argv);

    static int run();

    static IntegrationTestEnvironment* environment;

};
}
