#pragma once
#include "playercore/Log.hpp"
#include <gtest/gtest.h>
#include <string>

namespace twitch {
class TestOptions {
public:
    enum class StreamType {
        Unknown,
        Live,
        VOD
    };

    TestOptions() = default;

    bool parse(int argc, char** argv);

    StreamType getStreamType() const { return m_streamType; }
    const std::string& getUrl() const { return m_url; }
    Log::Level getLogLevel() const { return m_logLevel; }

private:
    bool setLogLevel(const std::string& logLevel);
    bool setStreamType(const std::string& streamType);

    Log::Level m_logLevel = Log::Level::Debug;
    StreamType m_streamType = StreamType::Unknown;
    std::string m_url;
};
}
