#pragma once

#include "playercore/Quality.hpp"
#include <gtest/gtest.h>
#include <memory>
#include <string>
#include <vector>

/**
 * Test Stream Configuration loads test parameters from a JSON config file
 */
namespace twitch {
namespace test {
struct TestStreamConfig {
public:
    // Boolean signifying if the test stream config has initialized
    bool isInitialized = false;

    // URL to test
    std::string url;

    // Expected qualities available for the stream
    struct Quality : twitch::Quality {
        Quality() = default;
        Quality(const twitch::Quality& quality);
        bool isValid() const { return !name.empty(); }
    };

    std::vector<Quality> expectedQualities;
    Quality defaultQuality;

    // FIXME: not sure why, but clang doesn't allow the use of protected constructors from load()
    explicit TestStreamConfig(const std::string& url);

    Quality getQuality(const std::string& name) const;

    ::testing::AssertionResult init();
};
}
}
