package tv.twitch.android.player.test;

import android.content.Context;
import android.support.test.InstrumentationRegistry;
import android.support.test.runner.AndroidJUnit4;

import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.Test;
import android.test.suitebuilder.annotation.LargeTest;
import android.view.Surface;
import android.provider.Settings;
import java.io.File;
import android.util.Log;
import android.os.Environment;

import java.nio.channels.FileChannel;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;


@RunWith(AndroidJUnit4.class)
@LargeTest
public class TestActivity {
    static {
        System.loadLibrary("playertest");
    }
    private native int runTests(Context context, Surface surface, String url, String filter, String xml);

    private Context context;

    @Before
    public void setup() {
        context = InstrumentationRegistry.getTargetContext();
    }

    @Test
    public void runner() {
        try{
            String storageDir = System.getProperty("appium.screenshots.dir", System.getProperty("java.io.tmpdir", ""));
            String xml = "--gtest_output=xml:" +  storageDir + "/IntegrationTester.xml";
            Log.i("Twitch", "GTEST-XML will  $ be written to: "+ xml);
            runTests(context, null, "", "", xml ); // TODO: Create and pass testing surface
            File dir = new File(storageDir);
            File[] list = dir.listFiles();
            for(int i=0; i<list.length;i++){
                if(list[i].getName().equals("IntegrationTester.xml"))
                copyFile( new File(storageDir + "/IntegrationTester.xml"), new File("/sdcard/TestResults.xml"));
            }
        }catch(Exception e){
            Log.i("Twitch", "Exception: "+ e);
        }
    }

    private void copyFile(File src, File dest) throws IOException {
        FileChannel srcChannel = null;
        FileChannel destChannel = null;
        try {
            srcChannel = new FileInputStream(src).getChannel();
            destChannel = new FileOutputStream(dest).getChannel();
            destChannel.transferFrom(srcChannel, 0, srcChannel.size());
        }
        finally {
            srcChannel.close();
            destChannel.close();
        }
    }
}
