package tv.twitch.android.player.test;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.WindowManager;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class TestActivity extends Activity implements TextureView.SurfaceTextureListener {

    static {
        System.loadLibrary("playertest");
    }

    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future future;
    private Surface surface;
    private TextureView textureView;
    private String url;
    private String gfilter;
    private String gxml;

    private native int runTests(Context context, Surface surface, String url, String filter, String xml);

    private void startTests() {
        if (future == null || future.isDone()) {
            future = executor.submit(new Runnable() {
                @Override
                public void run() {
                    int result = runTests(TestActivity.this, surface, url, gfilter, gxml);
                    Log.i("Twitch", "runTests returned: " + result);
                }
            });
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        setContentView(R.layout.activity_test);
        textureView = (TextureView) findViewById(R.id.textureView);
        textureView.setSurfaceTextureListener(this);

        // Get args, convert to proper format
        Intent intent = getIntent();
        if (intent != null ) {
            Bundle bundle = intent.getExtras();
            if (bundle != null ) {
                url = (String) bundle.get("url");
                if (bundle.containsKey("gfilter")) {
                    gfilter = "--gtest_filter=" + (String) bundle.get("gfilter");
                }
                if (bundle.containsKey("gxml")) {
                    String targetDir = getExternalFilesDir(null).getAbsolutePath();
                    gxml = "--gtest_output=xml:" +  targetDir + "/" + (String) bundle.get("gxml");
                }
            }
        }
        
        if (url == null ) {
            url = "";
        }
        if (gfilter == null) {
            gfilter = "";
        }
        if (gxml == null) {
            gxml = "";
        }

        Log.i( "Twitch", "onCreate: " + url + " " + gfilter + " " + gxml );
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (future != null) {
            future.cancel(true);
        }
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.surface = new Surface(surface);
        startTests();
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {

    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return false;
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {

    }
}
