#include <cstdlib>
#include <iostream>
#include <vector>
#include <memory>
#import <XCTest/XCTest.h>

#define MACRO_NAME(f) #f
#define MACRO_VALUE(f)  MACRO_NAME(f)

extern int runIntegrationTestFramework(int argc, char** argv);
@interface IntegrationTestDriver : XCTestCase
@end

@implementation IntegrationTestDriver

static std::string devicePath;
const char* xmlFileName="session_result.xml";
const char* logFileName="session_log.txt";

// Setup test case
- (void)setUp {
    [super setUp];
    // Put setup code here. This method is called before the invocation of each test method in the class.
#if TARGET_OS_SIMULATOR
    NSLog(@"Running in simulator");
    devicePath = "/tmp/TestDriver";
#else
    NSLog(@"Running on the device");
    NSString *str = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) lastObject];
    devicePath = std::string([str UTF8String]);
#endif
}

// Tear down test case
- (void)tearDown {
    // Put teardown code here. This method is called after the invocation of each test method in the class.
    [super tearDown];
}

// Perform test (calls into C++ testing framework and run the test suites)
- (void)testDriver {
    
    // Build command line parameters
    std::vector<const char*> argv = {
        "TestRunner",
    };

    // Test URL
    char testUrl[256];
    snprintf(testUrl, sizeof(testUrl), MACRO_VALUE(AUTO_TESTURL));
    argv.push_back(testUrl);
    
    // Test Filter
    char testFilter[256];
    snprintf(testFilter, sizeof(testFilter), "--gtest_filter=%s", MACRO_VALUE(AUTO_TESTFILTER));
    argv.push_back(testFilter);
    
    // XML output
    char xmlfile[256];
    snprintf(xmlfile, sizeof(xmlfile), "--gtest_output=xml:%s/%s", devicePath.c_str(), xmlFileName);
    argv.push_back(xmlfile);
    
    // Logfile output
    char logfile[256];
    snprintf(logfile, sizeof(logfile), "--logfile=%s/%s", devicePath.c_str(), logFileName);
    argv.push_back(logfile);

    // Run the test framework
    int result = runIntegrationTestFramework(static_cast<int>(argv.size()), const_cast<char**>(&argv[0]));
    
    XCTAssertEqual( 0, result );
}
@end
