#import "ViewController.h"
#import "TTVPlayerLayer.h"
#import "TTVAVPlayer.h"
#import <AVFoundation/AVFoundation.h>
#import <CoreMedia/CoreMedia.h>
#include "platforms/ios/ios_platform.h"
#include "testenv.hpp"
#include "IntegrationTest.hpp"
#include "TTVPlayerLayer.h"

@implementation ViewController

extern int gArgc;
extern const char** gArgv;
    
- (void)runTests
{
    printf("Playercore Integration TestRunner\n");
    for (int i = 0; i < gArgc; ++i) {
        printf("ARGV[%d] %s\n", i, gArgv[i]);
    }
    
    // TODO: Look at where CVP_TEST_ROOT is used in the test suites
    // char* test_root = getenv("CVP_TEST_ROOT");
    // if (test_root != NULL) {
    //    chdir(test_root);
    // } else {
    //    std::cerr << "CVP_TEST_ROOT is not set! some tests may fail." << std::endl;
    // }
    
    if (!twitch::IntegrationTest::initialize(gArgc, const_cast<char**>(gArgv))) {
        exit(EXIT_FAILURE);
    }
   
    // Obtain display layer and set in integration tester
    auto testEnvironment = twitch::TestEnvironment::current;
    if ( testEnvironment ) {
        auto platform = std::static_pointer_cast<twitch::IOSPlatform>(twitch::TestEnvironment::createTestPlatform());
        if ( platform && platform->getLayer() == nullptr ) {
            NSView *view = (NSView*)_playerView;
            view.layer = [[TTVPlayerLayer alloc] init];
            TTVPlayerLayer* playerLayer = (TTVPlayerLayer*) view.layer;
            platform->setLayer(playerLayer);
        }
    }
    twitch::IntegrationTest::run();
    exit(0);
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self performSelectorInBackground:@selector(runTests) withObject:nil];
}

@end
