#include "IntegrationTest.hpp"
#include "debug/exceptionhandler.hpp"
#include "debug/trace.hpp"
#include <iostream>
#include <stdexcept>
#include <thread>

//size_t sceLibcHeapSize = 512 * 1024 * 1024;
size_t sceUserMainThreadStackSize = 4 * 1024;
extern const char sceUserMainThreadName[] = "IntegrationTest";
int sceUserMainThreadPriority = SCE_KERNEL_PRIO_FIFO_DEFAULT;

int main(int argc, char** argv)
{
    using namespace twitch;

    ExceptionHandler::registerTerminateHandler(std::this_thread::get_id(), "IntegrationTest Main");

    if (!IntegrationTest::initialize(argc, argv)) {
        return EXIT_FAILURE;
    }

#ifdef __EXCEPTIONS
    try {
        return IntegrationTest::run();
    } catch (std::exception& e) {
        std::cerr << "Caught exception: " << e.what() << std::endl;
		return EXIT_FAILURE;
    }
#else
    return IntegrationTest::run();
#endif
}
