﻿#pragma once

#include "..\Common\DeviceResources.h"
#include "..\Common\TextureAndSRVNV12.hpp"
#include "..\Common\TextureMapper.hpp"

#include "ShaderStructures.h"

#include <mutex>

namespace IntegrationTestRunner {

class SampleRenderer {
public:
    SampleRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources);
    ~SampleRenderer();

    void CreateDeviceDependentResources();
    void CreateWindowSizeDependentResources();
    void ReleaseDeviceDependentResources();

    void Render();

    static const UINT DefaultTextureWidth = 1920;
    static const UINT DefaultTextureHeight = 1088;
       
private:
    void UpdateTexture();
private:

    // Cached pointer to device resources.
    std::shared_ptr<DX::DeviceResources> m_deviceResources;

    HRESULT m_hr;
    Microsoft::WRL::ComPtr<ID3D11InputLayout>   m_inputLayout;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        m_vertexBuffer;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        m_indexBuffer;
    Microsoft::WRL::ComPtr<ID3D11VertexShader>  m_vertexShader;
    Microsoft::WRL::ComPtr<ID3D11PixelShader>   m_pixelShader;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        m_constantBuffer;

    // Texture stuff
	std::shared_ptr<TextureMapper> m_textureMapper;

    // System resources for cube geometry.
    ModelViewProjectionConstantBuffer   m_constantBufferData;
    uint32  m_indexCount;

    // Variables used with the rendering loop.
    bool m_textureUpdated = false;
    bool m_loadingComplete;
    
    struct ImageInfo
    {
        Microsoft::WRL::ComPtr<ID3D11Texture2D> imageTexture;
        int imageWidth = 0;
        int imageHeight = 0;
    };

    std::mutex m_imageMutex;
    ImageInfo m_image;

};
}

