#include "IntegrationTestRunner.hpp"
#include "IntegrationTest.hpp"
#include "platforms/uwp/StringUtil.hpp"
#include <cstdlib>
#include <iostream>
#include <vector>

using namespace twitch::uwp;

namespace IntegrationTestRunner { 
    int Run()
    {
        // TODO: pass arguments in from CL
        std::vector<char*> argv = {
            "integrationTestRunner",
            "--gtest_catch_exceptions=0" // Important! Otherwise tests can be deadlocked
        };

        bool isXbox = Windows::System::Profile::AnalyticsInfo::VersionInfo->DeviceFamily->Equals("Windows.Xbox");
        FILE *logfile = NULL;
        const char *resultFilePath = "D:\\DevelopmentFiles\\IntegrationTest.xml";

        if (isXbox) {
            // Write XML to the installed UWP location
            Windows::Storage::StorageFolder^appDataDir = Windows::ApplicationModel::Package::Current->InstalledLocation;
            char xmlPath[512];
            size_t numCharConverted = 0;
            wcstombs_s(&numCharConverted, xmlPath, sizeof(xmlPath), appDataDir->Path->Data(), _TRUNCATE);
            char xmlOption[512];
            sprintf_s(xmlOption, sizeof(xmlOption), "--gtest_output=xml:%s\\IntegrationTest.xml", xmlPath);
            argv.push_back(xmlOption);

        } else {
            // Write XML to the installed UWP location
            char xmlOption[512];
            sprintf_s(xmlOption, "--gtest_output=xml:%s", resultFilePath);
            argv.push_back(xmlOption);

            const char *LOGFILE = "D:\\DevelopmentFiles\\logfile.txt";
            logfile = fopen(LOGFILE, "w");
            if (logfile) {
                _dup2(_fileno(logfile), _fileno(stdout));
                _dup2(_fileno(logfile), _fileno(stderr));
            }
        }
      
        int exitCode = 1;
        try {
            if (twitch::IntegrationTest::initialize(static_cast<int>(argv.size()), &argv[0])) {
                exitCode = twitch::IntegrationTest::run();
            }
        }
        catch (::Platform::Exception ^ e) {
            std::cerr << "TestRunner: Caught Platform::Exception: HRESULT=" << static_cast<int>(e->HResult) << " message=" << StringUtil::toString(e->Message).c_str();
        }
        catch (std::exception& e) {
            std::cerr << "TestRunner: Caught std::exception: " << e.what() << std::endl;
        }

        if (isXbox) {
            // Sanity check the existence of the test result file, and write it if it doesn't exist
            FILE *f;
            if ((f = fopen(resultFilePath, "r")) == nullptr) {
                const char content[] = "<?xml version=\"1.0\" encoding=\"UTF - 8\"?>"
                                       "<testsuites tests = \"1\" failures = \"1\" disabled = \"0\" "
                                       "errors = \"0\" timestamp = \"2019 - 01 - 01T00:00 : 00\" time = \"0.1\" "
                                       "name = \"AllTests\">< / testsuites >";
                f = fopen(resultFilePath, "w");
                if (f) {
                    fwrite(content, sizeof(char), sizeof(content), f);
                }
            }
            if (f) {
                fclose(f);
            }

            if (logfile) {
                fclose(logfile);
            }
        }
        return exitCode;
    }
}
