#include "test/common/testenv/testenv.hpp"
#include "test/common/testenv/web/webtestenv.hpp"
#include "platforms/web/web-platform.hpp"
#include "platforms/web/web-mediaplayer.hpp"
#include <emscripten/bind.h>
#include <emscripten/emscripten.h>
#include "debug/PrintLog.hpp"
#include "debug/trace.hpp"
#include "test/framework/playerstatetest.hpp"
#include "test/framework/TestRunner.hpp"

namespace twitch {
namespace test {

static WebMediaPlayer* s_testPlayer = nullptr;

extern "C" {
EMSCRIPTEN_KEEPALIVE
void runTests(void* player) {
    // TBD
    TRACE_WARN("RUN TESTS CALLED");
    s_testPlayer = reinterpret_cast<twitch::WebMediaPlayer*>(player);
    s_testPlayer->pause();

    class : public TestRunner::Listener {
        void onTestRunStart() override
        {
        }

        void onTestRunEnd(bool success) override
        {
            (void) success;
        }


    } testListener;
    
    TestRunner runner(testListener);
    WebTestEnvironment *m_webEnv = new WebTestEnvironment();
    m_webEnv->setPlayer(static_cast<twitch::WebMediaPlayer*> (player));
    
    TestEnvironment *m_env = new TestEnvironment();
    auto suite = stateTests(*m_env);

    for (const auto& test : suite->getCases()) {
        runner.addTest(test);
    }

    runner.run();
}
}

}
}

