/**
 * Integration config
 * https://webdriver.io/docs/configurationfile.html
 */

// tslint:disable-next-line:no-var-requires no-var-keyword no-require-imports
var base = require('../../../../../platforms/web/js/e2e/configs/base.conf.ts');

exports.config = Object.assign({}, base, {
    runner: 'local',
    specFileRetries: 3,
    capabilities: [
        {
            'browserName': 'chrome',
            'specs': ['./test/integration/app/web/integration-web-runner.ts'],
        },
        {
            browserName: 'firefox',
            specs: ['./test/integration/app/web/integration-web-runner.ts'],
        },
    ],
    logLevel: 'silent',
    bail: 0,
    waitforTimeout: 10000,
    connectionRetryTimeout: 90000,
    connectionRetryCount: 3,
    services: ['selenium-standalone', 'devtools'],
    framework: 'mocha',
    reporters: ['spec', ['junit', {
        outputFileFormat(options) {
            return `results-${options.cid}.${options.capabilities.browserName}.xml`;
        },
        outputDir: './results',
        errorOptions: {
            error: 'message',
            failure: 'message',
            stacktrace: 'stack',
        },
    }]],
    mochaOpts: {
        ui: 'bdd',
        /**
         * A single test should not take longer than the timeout.
         * Currently, buffering test take the longest at 240s
         * TODO: VP-6326 - Investigate setting timeouts per test
         */
        timeout: 5000,
        require: [
            'tsconfig-paths/register',
        ],
    },
    //
    // =====
    // Hooks
    // =====
    // WebdriverIO provides a several hooks you can use to interfere the test process in order to enhance
    // it and build services around it. You can either apply a single function to it or an array of
    // methods. If one of them returns with a promise, WebdriverIO will wait until that promise got
    // resolved to continue.
    //

    /**
     * Gets executed before test execution begins. At this point you can access to all global
     * variables like `browser`. It is the perfect place to define custom commands.
     * @param {Array.<Object>} capabilities list of capabilities details
     * @param {Array.<String>} specs List of spec file paths that are to be run
     */
    before: () => {
        // tslint:disable-next-line: no-require-imports
        require('ts-node').register({ files: true });
        browser.url(browser.options.baseUrl);
        browser.execute('runTests()');
    },
});
