const MediaPlayerPackage = window.MediaPlayerPackage = require('../../../../platforms/web/js/index');
const MediaPlayer = window.MediaPlayer = MediaPlayerPackage.MediaPlayer;
const PlayerEvent = window.PlayerEvent = MediaPlayerPackage.PlayerEvent;

// Create player for integration test
window.createPlayer = () => {
    const scripts = document.scripts;
    let mediaPlayerSrc;
    for (let i = 0; i < scripts.length; i++) {
        if (/testplayer(\.min)?\.js/.test(scripts[i].src)) {
            mediaPlayerSrc = scripts[i].src;
            break;
        }
    }
    const workerUrl = mediaPlayerSrc.replace(/[\w-\.]+\.js$/g, WASM_WORKER_URL);
    const wasmUrl = mediaPlayerSrc.replace(/[\w-\.]+\.js$/g, WASM_BINARY_URL);
    const worker = MediaPlayer.createWorker(workerUrl, wasmUrl);

    worker.addEventListener('error', function (e) {
        console.error('worker error:', e);
    });

    worker.addEventListener('message', function (e) {
        console.log('worker message', e);
    });

    var player = new MediaPlayer({
        logLevel: 'debug',
    }, worker);


    player.addEventListener(PlayerEvent.ERROR, function (err) {
        console.error('ERROR:', err);
    });

    return player;
}

// IIEF player for e2e test
const player = window.player = (window.createPlayer)();

document.getElementById('videoContainer').appendChild(player.getHTMLVideoElement());


window.runTests = function() {
    player.worker.postMessage({ id: player.id, funcName: 'runTests' });
};
