#pragma once
#include "IntegrationTest.hpp"
#include "player/MediaPlayer.hpp"
#include "player_listener.hpp"
#include "callback_monitor.hpp"
#include "state_change_monitor.hpp"
#include "player_state_machine.hpp"
#include "player_timeout_monitor.hpp"
#include <gtest/gtest.h>
#include "EmptyPlayerListener.hpp"
#include <vector>

using namespace twitch::test;
/**
 * Base class for MediaPlayer tests that will run on a given parameterized
 * set of test stream URL's
 */
class PlayerTestBase : public ::testing::Test, public EmptyPlayerListener {
public:
    PlayerTestBase();
    void SetUp() override;
    void TearDown() override;

protected:
    // Player::Listener overrides
    void onError(const twitch::Error& error) override;
    void onSeekCompleted(twitch::MediaTime) override;
    void onStateChanged(twitch::Player::State state) override;

    virtual void onRender(const twitch::MediaSample& sample, int width, int height)
    {
        (void)sample;
        (void)width;
        (void)height;
    }

    const twitch::IntegrationTestEnvironment::TestInputData& testInput() const { return m_environment->testData(); }

    const twitch::IntegrationTestEnvironment* m_environment;

    // MediaPlayer parameters
    std::shared_ptr<twitch::Log> m_log;

    // MediaPlayer
    std::shared_ptr<twitch::MediaPlayer> m_player;

    // MediaPlayer::load() parameter
    std::string m_url;

    // Every integration test is going to need to know about the player state
    std::unique_ptr<PlayerStateChangeMonitor> m_stateMonitor;
    std::unique_ptr<PlayerCallbackMonitor> m_callbackMonitor;
    std::unique_ptr<PlayerStateMachine> m_stateMachine;
};
