#include "hls/MasterPlaylist.hpp"
#include <fstream>
#include <gtest/gtest.h>
#include <streambuf>

// Sample playlists are in the 'samples' directory
using namespace twitch::hls;

TEST(MasterPlaylist, Live)
{
    std::ifstream manifest("samples/livemaster.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});
    MasterPlaylist playlist;
    playlist.parse(buffer, "https://www.twitch.tv/");
}

TEST(MasterPlaylist, Vod)
{
    std::ifstream manifest("samples/vodmaster.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});
    MasterPlaylist playlist;
    playlist.parse(buffer, "https://www.twitch.tv/");
}

TEST(MasterPlaylist, Captions)
{
    std::ifstream manifest("samples/captionsmaster.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});
    MasterPlaylist playlist;
    playlist.parse(buffer, "https://www.twitch.tv/");
}
// CVP-2070
TEST(MasterPlaylist, DISABLED_MissingInfo)
{
    std::ifstream manifest("samples/missinginfomaster.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});
    MasterPlaylist playlist;
    playlist.parse(buffer, "https://www.twitch.tv/");

    const auto& extraInfo = playlist.getSessionData();
    ASSERT_TRUE(extraInfo.count("REGION") > 0) << "Empty field not in map";
}
// CVP-2069
TEST(MasterPlaylist, DISABLED_Subtitles)
{
    std::ifstream manifest("samples/bipbop.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});
    MasterPlaylist playlist;
    playlist.parse(buffer, "https://www.twitch.tv/");

    ASSERT_TRUE(playlist.parsed());
}
