#include "hls/MasterPlaylist.hpp"
#include "hls/MediaPlaylist.hpp"
#include "gtest/gtest.h"
#include <fstream>
#include <streambuf>

using namespace twitch::hls;
// Sample playlists are in the 'samples' directory
TEST(VariantPlaylist, Live)
{
    MediaPlaylist playlist;
    std::ifstream manifest("samples/livevariant.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});

    playlist.parse(buffer);
}

TEST(VariantPlaylist, Vod)
{
    MediaPlaylist playlist;
    std::ifstream manifest("samples/vodvariant.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});

    playlist.parse(buffer);
}

TEST(VariantPlaylist, DateTime)
{
    MediaPlaylist playlist;
    std::ifstream manifest("samples/datetimevariant.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});

    playlist.parse(buffer);
    std::string result = playlist.generate();
    MediaPlaylist playlist2;
    playlist2.parse(result);
    ASSERT_EQ(playlist2.segments()[0].dateRanges.size(), static_cast<size_t >(1));
    ASSERT_EQ(playlist.segments()[0].dateRanges.size(), playlist2.segments()[0].dateRanges.size());
}

TEST(VariantPlaylist, ByteRange)
{
    MediaPlaylist playlist;
    std::ifstream manifest("samples/byterangevariant.m3u8");
    std::string buffer(std::istreambuf_iterator<char>(manifest), {});

    playlist.parse(buffer);
    std::string result = playlist.generate();
    ASSERT_STREQ(buffer.c_str(), result.c_str());
}