#include "media/CodecString.hpp"
#include <cstring>
#include <gtest/gtest.h>

using namespace twitch::media;
using namespace ::testing;
using namespace ::testing::internal;

TEST(CodecString, ParseVP9Parameters)
{
    std::string vp9codecs ="vp09.02.10.10.01.09.16.09.01";
    CodecString cs = CodecString::parse(vp9codecs);
    CodecString::VP9Parameters parameters{};
    cs.parseVP9Parameters(parameters);

    EXPECT_EQ(2, parameters.profile) << "Incorrect profile";
    EXPECT_EQ(10, parameters.level) << "Incorrect level";
    EXPECT_EQ(10, parameters.bitDepth) << "Incorrect bit depth";
    EXPECT_EQ(0x01, parameters.chromaSubsampling) << "Incorrect chromaSubsampling";
    EXPECT_EQ(true, parameters.videoFullRangeFlag) << "Incorrect videoFullRangeFlag";
}

TEST(CodecString, ParseAvcHex)
{
    std::string avcCodecs ="avc1.4D402A";
    CodecString cs = CodecString::parse(avcCodecs);
    CodecString::AVCParameters parameters{};
    cs.parseAVCParameters(parameters);

    EXPECT_EQ(77, parameters.profile) << "Incorrect profile";
    EXPECT_EQ(42, parameters.level) << "Incorrect level";
}

TEST(CodecString, ParseAvcDec)
{
    std::string avcCodecs ="avc1.77.31";
    CodecString cs = CodecString::parse(avcCodecs);
    CodecString::AVCParameters parameters{};
    cs.parseAVCParameters(parameters);

    EXPECT_EQ(77, parameters.profile) << "Incorrect profile";
    EXPECT_EQ(31, parameters.level) << "Incorrect level";
}
