#include "media/mp4/fmp4.hpp"
#include <gtest/gtest.h>

namespace {

const std::array<uint8_t, 16> TEST_KID_ARRAY_1 = {{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
const std::array<uint8_t, 16> TEST_KID_ARRAY_2 = {{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}};
using namespace twitch::media;
class Fmp4MuxerTest : public ::testing::Test {
 public:
  std::vector<EncryptionInfo> getEncryptionInfos()
  {
      std::vector<EncryptionInfo> infos;
      for (int i = 1; i <= 5; i++) {
          EncryptionInfo info;
          info.kid = i == 1 ? TEST_KID_ARRAY_1 : TEST_KID_ARRAY_2;
          info.key = info.kid;
          info.scheme = i == 1 ? fourcc("cenc") : fourcc("cbcs");
          info.pssh.push_back(Mp4DrmFactory::generateTwitchPssh(info.kid));
          infos.push_back(info);
      }
      return infos;
  }
protected:
    void SetUp() override
    {
    }

    void TearDown() override
    {
    }

    std::shared_ptr<fmp4track_avc> m_videoTrack;
    std::shared_ptr<fmp4track_aac> m_audioTrack;
};

// Key rotation temporarily disabled
// TEST_F(Fmp4MuxerTest, RotateEncryptionInfo)
// {
//     std::vector<uint8_t> extradata;
//     std::vector<fmp4drmFactory::encryptionInfo> info = getEncryptionInfos();
//     m_videoTrack = std::make_shared<fmp4track_avc>(2,
//                                                    MOOV_TIMESCALE,
//                                                    0,
//                                                    SAMPLE_IS_INTRA,
//                                                    (MOOV_TIMESCALE / 30),
//                                                    0,
//                                                    extradata,
//                                                    info);

//     EXPECT_EQ(m_videoTrack->curEncryptionIndex(), 0u);
//     for (uint32_t i = 0; i < m_videoTrack->curEncryptionInfo().kid.size(); i++) {
//         EXPECT_EQ(m_videoTrack->curEncryptionInfo().kid[i], TEST_KID_ARRAY_1[i]);
//     }

//     m_videoTrack->rotateEncryptionInfo();

//     EXPECT_EQ(m_videoTrack->curEncryptionIndex(), 1u);
//     for (uint32_t i = 0; i <m_videoTrack->curEncryptionInfo().kid.size(); i++) {
//         EXPECT_EQ(m_videoTrack->curEncryptionInfo().kid[i], TEST_KID_ARRAY_2[i]);
//     }

//     for (int i = 0; i < 4; i++) {
//         m_videoTrack->rotateEncryptionInfo();
//     }

//     EXPECT_EQ(m_videoTrack->curEncryptionIndex(), 0u);
//     for (uint32_t i = 0; i < m_videoTrack->curEncryptionInfo().kid.size(); i++) {
//         EXPECT_EQ(m_videoTrack->curEncryptionInfo().kid[i], TEST_KID_ARRAY_1[i]);
//     }

//     EXPECT_EQ(m_videoTrack->encryptionInfo().size(), 5u);
// }

// TEST_F(Fmp4MuxerTest, SetEncryptionForTrack)
// {
//     std::vector<uint8_t> extradata;
//     std::vector<fmp4drmFactory::encryptionInfo> info;
//     m_videoTrack = std::make_shared<fmp4track_avc>(2,
//                                                    MOOV_TIMESCALE,
//                                                    0,
//                                                    SAMPLE_IS_INTRA,
//                                                    (MOOV_TIMESCALE / 30),
//                                                    0,
//                                                    extradata,
//                                                    std::vector<fmp4drmFactory::encryptionInfo>());

//     EXPECT_EQ(m_videoTrack->curEncryptionInfo().scheme, 0u);

//     info = getEncryptionInfos();
//     m_videoTrack->setEncryptionInfo(info);

//     for (uint32_t i = 0; i < m_videoTrack->curEncryptionInfo().kid.size(); i++) {
//         EXPECT_EQ(m_videoTrack->curEncryptionInfo().kid[i], TEST_KID_ARRAY_1[i]);
//     }
//     EXPECT_EQ(m_videoTrack->curEncryptionInfo().scheme, FOURCC("cenc"));

//     m_videoTrack->rotateEncryptionInfo();

//     for (uint32_t i = 0; i < m_videoTrack->curEncryptionInfo().kid.size(); i++) {
//         EXPECT_EQ(m_videoTrack->curEncryptionInfo().kid[i], TEST_KID_ARRAY_2[i]);
//     }
//     EXPECT_EQ(m_videoTrack->curEncryptionInfo().scheme, FOURCC("cbcs"));
// }

}
