#pragma once

#include "playercore/MediaDecoder.hpp"
#include <gmock/gmock.h>
#include <thread>

class MockMediaDecoder : public twitch::MediaDecoder {
public:
    MockMediaDecoder() = default;
    ~MockMediaDecoder() override = default;

    // MockSink
    MOCK_METHOD0(flush, twitch::MediaResult());
    MOCK_METHOD0(reset, twitch::MediaResult());

    // MediaDecoder
    MOCK_METHOD2(configure, twitch::MediaResult(const twitch::MediaFormat&, twitch::MediaFormat&));
    MOCK_METHOD1(decode, twitch::MediaResult(const twitch::MediaSample&));
    MOCK_METHOD1(hasOutput, twitch::MediaResult(bool&));
    MOCK_METHOD1(getOutput, twitch::MediaResult(twitch::MediaSample&));

    void sleepOnDecode()
    {
        ON_CALL(*this, decode(::testing::_))
            .WillByDefault(testing::Invoke([](const twitch::MediaSample& sample) {
                std::this_thread::sleep_for(sample.duration.milliseconds());
                return twitch::MediaResult::Ok;
            }));
    }
};

// NOTE: Cannot use Field/Property matchers for std::shared_ptr, so need to create custom matcher
//      see: https://groups.google.com/forum/#!msg/googlemock/tIhbRQV1BdU/7ifq3A-vpucJ
MATCHER_P(IsMediaType, mediaType, "") { return arg->getType() == mediaType; }
