#pragma once
#include "playercore/MediaDecoder.hpp"
#include "playercore/MediaRenderer.hpp"
#include <cassert>
#include <gmock/gmock.h>
#include "player/MediaPlayer.hpp"

/**
 * Mock twitch::MediaPlayer
 */
class MockMediaPlayer : public twitch::MediaPlayer {
protected:
    /**
     * Interface for twitch::MediaPlayer::SourceFactory
     */
    class ISourceFactory {
    public:
        virtual ~ISourceFactory() = default;
        virtual std::unique_ptr<twitch::MediaSource> load(const std::string& path) = 0;
    };
};
