#pragma once

#include "playercore/MediaSource.hpp"
#include "playercore/Quality.hpp"
#include <gmock/gmock.h>

class MockMediaSource : public twitch::MediaSource {
public:
    MockMediaSource() = default;
    ~MockMediaSource() override = default;

    MOCK_METHOD0(open, void());
    MOCK_METHOD0(close, void());
    MOCK_CONST_METHOD0(isLive, bool());
    MOCK_CONST_METHOD0(isPassthrough, bool());
    MOCK_CONST_METHOD0(isSeekable, bool());
    MOCK_METHOD1(seekTo, void(twitch::MediaTime));
    MOCK_METHOD1(read, void(const twitch::TimeRange&));
    MOCK_CONST_METHOD0(getDuration, twitch::MediaTime());
    MOCK_CONST_METHOD0(getStartOffset, twitch::MediaTime());
    MOCK_CONST_METHOD0(getQualities, const std::vector<twitch::Quality>&());
    MOCK_CONST_METHOD0(getQuality, const twitch::Quality&());
    MOCK_METHOD2(setQuality, void(const twitch::Quality&, bool));
    MOCK_CONST_METHOD0(getAutoSwitchQuality, bool());
    MOCK_CONST_METHOD0(getProperties, const std::map<std::string, std::string>&());
    MOCK_METHOD1(setReadTimeout, void(twitch::MediaTime));
    MOCK_METHOD1(setLowLatencyEnabled, void(bool));
};
