#pragma once

#include "playercore/platform/NativePlatform.hpp"
#include <gmock/gmock.h>

class MockPlatform : public twitch::NativePlatform {
public:
    MockPlatform() = default;
    ~MockPlatform() override = default;

    MOCK_METHOD1(createScheduler, std::shared_ptr<twitch::Scheduler>(const std::string& name));
    MOCK_METHOD1(createDecoder, std::unique_ptr<twitch::MediaDecoder>(std::shared_ptr<const twitch::MediaFormat>));
    MOCK_METHOD2(createRenderer, std::unique_ptr<twitch::MediaRenderer>(const twitch::ReferenceClock& clock, std::shared_ptr<const twitch::MediaFormat>));
    MOCK_METHOD2(createSink, std::unique_ptr<twitch::MediaSink>(twitch::MediaSink::Listener& listener, std::shared_ptr<twitch::Scheduler> scheduler));
    MOCK_METHOD4(createSource, std::unique_ptr<twitch::MediaSource>(const std::string& path, const twitch::MediaType&, twitch::MediaSource::Listener& listener, std::shared_ptr<twitch::Scheduler> scheduler));
    MOCK_CONST_METHOD0(getLog, std::shared_ptr<twitch::Log>());
    MOCK_CONST_METHOD0(getHttpClient, std::shared_ptr<twitch::HttpClient>());
    MOCK_CONST_METHOD0(getName, const std::string&());
    MOCK_CONST_METHOD0(getCapabilities, const twitch::Capabilities&());
    MOCK_CONST_METHOD0(getTempPath, const std::string&());
    MOCK_METHOD2(onThreadCreated, void(std::thread::id, const std::string&));
    MOCK_METHOD1(setCurrentThreadName, void(const std::string&));
    MOCK_METHOD0(getAnalyticsProperties, const std::map<std::string, std::string>&());
    MOCK_CONST_METHOD0(getMediaReaderFactory, std::shared_ptr<twitch::MediaReaderFactory>());

    const std::map<std::string, std::string>& getAnalyticsPropertiesConcrete() { return twitch::NativePlatform::getAnalyticsProperties(); };
};
