#include "MediaTime.hpp"
#include <gtest/gtest.h>

using namespace twitch;
using namespace ::testing;
using namespace ::testing::internal;

TEST(TimeTest, MicrosecondsScale)
{
    int32_t intmax = std::numeric_limits<int32_t>::max();
    MediaTime time(intmax, std::micro::den);

    EXPECT_EQ(time.microseconds().count(), intmax) << "Microseconds conversion failed";
    EXPECT_EQ(time.timebase(), std::micro::den) << "Non microsecond timebase";
}

TEST(TimeTest, MicrosecondsMultiply)
{
    MediaTime time(1000000, std::micro::den);
    time += MediaTime(1000, std::milli::den);

    EXPECT_EQ(time.microseconds().count(), 2000 * std::milli::den) << "Microseconds multiplication failed";
    EXPECT_EQ(time.timebase(), std::micro::den) << "Non microsecond timebase";
}

TEST(TimeTest, NanosecondsScale)
{
    int32_t intmax = std::numeric_limits<int32_t>::max();
    MediaTime time(intmax, std::nano::den);

    EXPECT_EQ(time.nanoseconds().count(), intmax) << "Nanoseconds conversion failed";
    EXPECT_EQ(time.timebase(), std::nano::den) << "Non nanoseconds timebase";
}
