#include "playercore/platform/NativePlatform.hpp"
#include "mock_platform.hpp"
#include <gtest/gtest.h>

using namespace twitch;
using namespace ::testing;
using ::testing::_;


TEST(NativePlatformTest, getAnalyticsProperties)
{
	NiceMock<MockPlatform> platform;
  	ON_CALL(platform, getAnalyticsProperties()).WillByDefault(Invoke(&platform, &MockPlatform::getAnalyticsPropertiesConcrete));

	const std::map<std::string, std::string>& properties = platform.getAnalyticsProperties();

    EXPECT_TRUE(properties.empty()) << "should be an empty string map";
}
