#include "player/Settings.hpp"
#include <gtest/gtest.h>

TEST(Setting, Basic)
{
    int ivalue1 = 12345;
    bool bvalue1 = false;
    double fvalue1 = 0.0;
    std::string svalue1 = "Hello World";
    std::string json = R"'({"test1":{"ivalue":7,"bvalue":true,"fvalue":3.14,"svalue":"Hello World"}})'";
    twitch::Settings s1(json);
    EXPECT_EQ(7, s1.get("test1", "ivalue", ivalue1)) << "Setting not as expected";
    EXPECT_EQ(true, s1.get("test1", "bvalue", bvalue1)) << "Setting not as expected";
    EXPECT_EQ(3.14, s1.get("test1", "fvalue", fvalue1)) << "Setting not as expected";
    EXPECT_EQ("Hello World", s1.get("test1", "svalue", svalue1)) << "Setting not as expected";

    twitch::Settings s2;
    EXPECT_EQ(ivalue1, s1.get("test1", "ivalue0", ivalue1)) << "Setting not as expected";
    EXPECT_EQ(bvalue1, s1.get("test1", "bvalue0", bvalue1)) << "Setting not as expected";
    EXPECT_EQ(fvalue1, s1.get("test1", "fvalue0", fvalue1)) << "Setting not as expected";
    EXPECT_EQ(svalue1, s1.get("test1", "svalue0", svalue1)) << "Setting not as expected";
    EXPECT_EQ(ivalue1, s2.get("test2", "ivalue", ivalue1)) << "Setting not as expected";
    EXPECT_EQ(bvalue1, s2.get("test2", "bvalue", bvalue1)) << "Setting not as expected";
    EXPECT_EQ(fvalue1, s2.get("test2", "fvalue", fvalue1)) << "Setting not as expected";
    EXPECT_EQ(svalue1, s2.get("test2", "svalue", svalue1)) << "Setting not as expected";
}
