#
# The "CMakeLists.txt" for adding googletest and googlemock into our subprojects
#
# Ideally, we should just be able to call `add_subdirectory(${VENDOR_DIR)/googletest})`
# to use googletest's CMakeLists.txt as a subproject, but there were numerous issues
# with the compiler flags (specifically, the runtime flags on Windows) that made
# this extremely difficult.
#
# As a result, it was much easier to add the libraries and executables ourselves,
# especially since we need to control some of the linking libraries (i.e. adding
# the posix stubs for PS4)
#

# googletest
set(gtest_dir googletest/googletest)

# gtest
add_library(gtest ${gtest_dir}/src/gtest-all.cc)
set_target_properties(gtest PROPERTIES FOLDER vendor/googletest)
target_include_directories(gtest PRIVATE ${gtest_dir})
target_include_directories(gtest PUBLIC ${gtest_dir}/include)

if(PS4)
  target_link_libraries(gtest PRIVATE SceRtc_stub_weak ScePosix_stub_weak)
elseif(NOT ANDROID AND NOT WEB AND NOT IOS AND NOT WIN32) # TODO: create alias for posix?
  target_compile_definitions(gtest PRIVATE GTEST_HAS_PTHREAD=1)
  target_link_libraries(gtest PRIVATE pthread)
endif()

# gtest_main
add_library(gtest_main ${gtest_dir}/src/gtest_main.cc)
target_link_libraries(gtest_main PUBLIC gtest)
set_target_properties(gtest_main PROPERTIES FOLDER vendor/googletest)

# googlemock
set(gmock_dir googletest/googlemock)

# gmock
add_library(gmock ${gmock_dir}/src/gmock-all.cc)
target_include_directories(gmock PRIVATE ${gmock_dir})
target_include_directories(gmock PUBLIC ${gmock_dir}/include)
target_link_libraries(gmock PUBLIC gtest)
set_target_properties(gmock PROPERTIES FOLDER vendor/googletest)

# gmock_main
add_library(gmock_main ${gmock_dir}/src/gmock_main.cc)
target_link_libraries(gmock_main PUBLIC gmock)
set_target_properties(gmock_main PROPERTIES FOLDER vendor/googletest)
