[![Go Report Card](https://goreportcard.internal.justin.tv/badge/code.justin.tv/safety/aegis)](https://goreportcard.internal.justin.tv/report/code.justin.tv/safety/aegis)

# Aegis

Aegis is the Next Generation of Site Moderation tools.

## Installing

- `yarn`
- ( Optional: [`nvm`](https://github.com/nvm-sh/nvm) )

## Running locally

- Node needs to be 8.x
  ( [`nvm use`](https://github.com/nvm-sh/nvm) makes setup painless )
- In one console:
  `AWS_SDK_LOAD_CONFIG=true AWS_REGION=us-west-2 AWS_PROFILE=twitch-safety-staging make dev`
- In another:
  `yarn start`

#### Notes:

- Janky for now (been for now for a while, we should probably take a look at it sometime), need 2 consoles
- We really should switch back to localstorage after guardian allows wildcard redirect url. https://bugs.chromium.org/p/chromium/issues/detail?id=56211
  - Blocked by https://jira.twitch.com/browse/SECDEV-1121

## Contributing

This is a general guidance about some common areas for contributing to Aegis.

#### Deploy

Please ping one of the safety engineers to make a release and deploy.

#### Managing dependencies

- All current client should already been cached under `vendor/`, if you are not going to add a new dependency, it should be good to go.
- For adding a new dependency package, Aegis backend is using [`dep`](https://golang.github.io/dep/) for dependency management.

  Adding a service client to Aegis can through `dep ensure -add` command with package version, example:

  `dep ensure -add code.justin.tv/web/users-service@1.0`

  Or you can add package name with revision (a specific commit of package) within `Gopkg.toml` and rerun `dep ensure`, example:

  ```
  [[constraint]]
       name = "code.justin.tv/amzn/JaegerLambdaTwirp"
       revision = "d33936a6da2cc3a8f7bc7c4f3718f57a86bf782f"
  ```

#### Testing locally

- GraphQL

  In one console:
  `AWS_SDK_LOAD_CONFIG=true AWS_PROFILE=twitch-safety-staging make dev`
  Playground: `http://localhost:8000/graphql`

  [GraphQL playground](https://github.com/prisma/graphql-playground) is a useful tool for GraphQL development.

  For making the call by using GraphQL Playground, you have to add authorization information under `HTTP HEADERS` section.
  After login within Aegis staging on a web page -> `inspect` that page, -> `Application` -> `aegis-auth-token`.
  After you got the Aegis auth token, go to play ground and add the follow block into `HTTP HEADERS`:

  ```
  {
    "Authorization": "Bearer ${aegis-auth-token}"
  }
  ```

  Now you will be able to test GraphQL change within GraphQL playground

- React

  Please following [Running locally](https://git-aws.internal.justin.tv/safety/aegis#running-locally) above

#### Running unit test and format code

- GraphQL development, before commit, please run the following commands:
  1.  For running test locally: `make test-go`
  2.  For standardize code: `make lint-go`
  - Note: Backend is using [`goimports`](https://godoc.org/golang.org/x/tools/cmd/goimports) for formatting, please follow the instruction within previous link
- Frontend development, before commit, please run the following commands:
  1.  For running test locally: `make test-react`
  2.  For standardize code: `make lint-react`
- To run combined commands covering all, please use the following commands:
  1.  Testing: `make test`
  2.  Format code: `make lint`

## Staging Build

A staging build is created for every PR. You can access staging build by going to https://aegis-pr-XX.service.safety-staging.justin.tv.
To log into PR builds, first go to https://aegis.service.safety-staging.justin.tv, log in. Then go to the pr build and you should be logged in automatically.

## Running integration tests locally

### install Sandstorm-cli (one time)

`go get -u code.justin.tv/systems/sandstorm/cmd/sandstorm-cli`

### Actually running

Run the following commands in different windows, need to set your `AWS_PROFILE`

```
make integration-server
make integration-test-debug
```

### Upgrading the version of chromium and puppeteer

See https://git-aws.internal.justin.tv/safety/builder/pull/17

## Useful urls

- Jenkins - https://jenkins.internal.justin.tv/view/safety/job/safety/job/aegis/
- Deploy - https://clean-deploy.internal.justin.tv/#/safety/aegis

## S2S

In order hit s2s protected staging services, you need to add your iam role to our staging s2s service

- Go to https://dashboard.internal.justin.tv/s2s/services, search for "aegis-staging"
- Under allowed ARNs, add your iam arn and you should be good to go
