package main

import (
	"context"
	"log"

	"github.com/pkg/errors"

	"goji.io/pat"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/foundation/twitchserver"
	"code.justin.tv/safety/aegis/integration/api"

	twitchConfig "code.justin.tv/common/config"
)

func main() {
	err := twitchConfig.Parse()
	if err != nil {
		log.Fatalf("Failed to parse config: %v", err)
	}

	defer logx.Wait()
	defer logx.RecoverAndLog()

	ctx := context.Background()

	router := twitchserver.NewServer()
	apiMux, err := api.NewSubMux()
	if err != nil {
		logx.Fatal(ctx, errors.WithMessage(err, "failed to create API mux"))
	}

	router.Handle(pat.New("/test/*"), apiMux)

	twitchserver.AddDefaultSignalHandlers()
	conf := twitchserver.NewConfig()
	conf.Addr = ":8001"
	conf.DebugAddr = ":6001"
	err = twitchserver.ListenAndServe(router, conf)
	if err != nil {
		logx.Fatal(ctx, errors.WithMessage(err, "ListenAndServe failed"))
	}
}
