package clients

// Clients contains clients used by integration tests
type Clients struct {
	Users   *UsersClient
	Gateway *GatewayClient
}

// NewClients creates new clients for integration tests
func NewClients() (*Clients, error) {
	users, err := newUsersClient()
	if err != nil {
		return nil, err
	}

	gateway := newGatewayClient()

	return &Clients{
		Users:   users,
		Gateway: gateway,
	}, nil
}
