package api

import (
	"context"
	"net/http"

	"github.com/jixwanwang/apiutils"

	"code.justin.tv/chat/golibs/logx"

	"code.justin.tv/safety/aegis/integration/api/clients"
	goji "goji.io"
	"goji.io/pat"
)

// Server defines a rest server
type Server struct {
	clients *clients.Clients
}

// NewSubMux creates a new server that's wrapped in goji.SubMux()
func NewSubMux() (*goji.Mux, error) {
	clients, err := clients.NewClients()
	if err != nil {
		return nil, err
	}

	s := &Server{
		clients: clients,
	}

	mux := goji.SubMux()
	mux.Handle(pat.Get("/single_report_page"), s.CaseSingleReportPage())

	return mux, nil
}

func serveError(ctx context.Context, w http.ResponseWriter, statusCode int, msg string, err error) {
	logx.Error(ctx, msg, logx.Fields{
		"error": err,
	})

	apiutils.ServeError(w, apiutils.NewErrorResponse(statusCode, msg))
}
