package auth

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

const (
	clientID     = "ClientID"
	clientSecret = "ClientSecret"
)

func TestConfigIsValidatedBadConfig(t *testing.T) {
	t.Parallel()
	ret, err := New(Config{})
	require.Nil(t, ret)
	require.Error(t, err)
}

func TestConfigUsed(t *testing.T) {
	t.Parallel()
	ret, err := New(Config{
		GuardianClientID:     clientID,
		GuardianClientSecret: clientSecret,
	})

	require.NoError(t, err)
	require.NotNil(t, ret)

	oauthConfig := ret.oauthConfig
	require.NotNil(t, oauthConfig)
	assert.Equal(t, clientID, oauthConfig.ClientID)
	assert.Equal(t, clientSecret, oauthConfig.ClientSecret)
}
