package auth

import (
	"strings"
)

// Config contains the configuration parameters required to create
// an instance of the Auth object
type Config struct {
	// Authentication
	GuardianClientID     string
	GuardianClientSecret string `json:"-"`
}

// validate validates the config. It returns an error if the config is invalid
func (c Config) validate() error {
	if len(strings.TrimSpace(c.GuardianClientID)) == 0 {
		return ErrGuardianClientIDRequired
	}
	if len(strings.TrimSpace(c.GuardianClientSecret)) == 0 {
		return ErrGuardianClientSecretRequired
	}
	return nil
}
