package auth

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestConfig(t *testing.T) {
	t.Parallel()
	c := Config{}

	err := c.validate()
	require.Equal(t, ErrGuardianClientIDRequired, err)

	c.GuardianClientID = "ClientID"
	err = c.validate()
	require.Equal(t, ErrGuardianClientSecretRequired, err)

	c.GuardianClientSecret = "ClientSecret"
	err = c.validate()

	require.NoError(t, err)
}
