package auth

const (
	noRedirectNonce = "NoRedirect"
)

// staticNonceStore implements guardian.NonceStore
//
// Guardian requires nonce to be non empty string
// Nonce is used to prevent redirect attacks, which is not a concern for our app.
// The page isn't redirected after user is authenticated, and thus having a static value
// is not introducing additional security risks.
type staticNonceStore struct {
}

// Generate a static nonce that doesn't support redirect
func (n *staticNonceStore) Generate() (string, error) {
	return noRedirectNonce, nil
}

// Check if static nonce exists
func (n *staticNonceStore) Check(nonce string) (bool, error) {
	return nonce == noRedirectNonce, nil
}
