package auth

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNonceStoreMatch(t *testing.T) {
	n := &staticNonceStore{}
	nonce, err := n.Generate()
	assert.NoError(t, err)

	res, err := n.Check(nonce)
	assert.NoError(t, err)
	assert.True(t, res)
}
func TestNonceStoreUnmatch(t *testing.T) {
	n := &staticNonceStore{}
	nonce, err := n.Generate()
	assert.NoError(t, err)

	res, err := n.Check(nonce + "big fluffy puppy")
	assert.NoError(t, err)
	assert.False(t, res)
}
