package clients

import (
	"github.com/aws/aws-sdk-go/aws/client"

	"code.justin.tv/safety/aegis/internal/clients/guardian"
	"code.justin.tv/safety/aegis/internal/permissions"
)

// Clients contains all the clients
type Clients struct {
	Guardian    guardian.Client
	Permissions *permissions.Permissions
}

// Create creates Clients
func Create(config Config, awsSession client.ConfigProvider) (*Clients, error) {
	// s3Client := s3.New(awsSession)

	// var cfg *caller.Config
	// logger := logrus.New()

	// s2sRoundTripper, err := caller.NewRoundTripper(config.S2SServiceName, cfg, logger)
	// if err != nil {
	// return nil, errors.Wrapf(err, "Creating s2sRoundTripper with %s", config.S2SServiceName)
	// }
	// s2sTripperWrapper := func(inner http.RoundTripper) (outer http.RoundTripper) {
	// s2sRoundTripper.SetInnerRoundTripper(inner)
	// return s2sRoundTripper
	// }

	// badgesClient, err := badges.NewClient(twitchclient.ClientConf{
	// Host: config.BadgesEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// channels, err := usersservice_channels.NewClient(twitchclient.ClientConf{
	// Host: config.UserServiceEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// clipsClient, err := clips.NewClient(twitchclient.ClientConf{
	// Host: config.ClipsEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// clueClient, err := clue.NewClient(twitchclient.ClientConf{
	// Host: config.ClueEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// devicesClient := devices.NewDevicesProtobufClient(config.DevicesEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{
	// Host: config.DevicesEndpoint,
	// }))

	guardianClient, err := guardian.New(config.GuardianEndpoint)
	if err != nil {
		return nil, err
	}

	// gatewayClient := gateway.NewGatewayProtobufClient(config.GatewayEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{
	// Host: config.GatewayEndpoint,
	// }))

	// fileUploader := &fileuploader.S3UploadClient{
	// Config:   config.FileUploader,
	// S3Client: s3Client,
	// }

	// flipperClient, err := flipper.NewClient(twitchclient.ClientConf{
	// Host: config.FlipperEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// jaxClient, err := jax.NewClient(twitchclient.ClientConf{
	// Host: config.JaxEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// makoCLient := mako.NewMakoProtobufClient(config.MakoEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{
	// Host: config.RipleyEndpoint,
	// }))

	// ripleyClient := riptwirp.NewRipleyProtobufClient(config.RipleyEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{
	// Host: config.RipleyEndpoint,
	// }))

	// users, err := usersservice.NewClient(twitchclient.ClientConf{
	// Host: config.UserServiceEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// panels, err := pms.NewClient(twitchclient.ClientConf{
	// Host: config.PanelServiceEndpoint,
	// })
	// if err != nil {
	// return nil, err
	// }

	// passport, err := passport.New("https://passport.internal.us-west-2.twitch.tv")
	// if err != nil {
	// return nil, err
	// }

	// paydayClient, err := payday.NewClient(twitchclient.ClientConf{
	// Host:                 config.PaydayEndpoint,
	// RoundTripperWrappers: []func(http.RoundTripper) http.RoundTripper{s2sTripperWrapper},
	// })
	// if err != nil {
	// return nil, err
	// }

	// permissions, err := permissions.New(config.Permissions, s2sTripperWrapper)
	// if err != nil {
	// return nil, err
	// }

	// trackingClient, err := tracking.New(config.SpadeConfig)
	// if err != nil {
	// return nil, err
	// }

	// discoveryClient, err := discovery.NewClient(twitchclient.ClientConf{
	// Host: config.DiscoveryEndPoint,
	// })
	// if err != nil {
	// return nil, err // Fail immediately if constructor returns an error
	// }

	// namesClient := names.NewNamesProtobufClient(config.NamesEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{}))

	// subscriptionsClient := subscriptions.NewSubscriptionsProtobufClient(config.SubscriptionsEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{}))

	// chatroomsClient := chatrooms.NewChatroomsProtobufClient(config.ChatroomsEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{}))

	// vodClient := vodapi.NewVodApiProtobufClient(config.VodAPIEndpoint, twitchclient.NewHTTPClient(twitchclient.ClientConf{}))

	// jaegerTransportClient := lambda_transport.NewClient(lambda.New(awsSession), config.JaegerLambdaEndPoint)
	// jaegerClient := jaeger.NewJaegerServiceProtobufClient("", jaegerTransportClient)

	return &Clients{
		// Badges:        badgesClient,
		// Channels:      channels,
		// Chatrooms:     chatroomsClient,
		// Clips:         clipsClient,
		// Clue:          clueClient,
		// Devices:       devicesClient,
		// Discovery:     discoveryClient,
		// FileUpoader:   fileUploader,
		// Flipper:       flipperClient,
		Guardian: guardianClient,
		// Gateway:       gatewayClient,
		// Jaeger:        jaegerClient,
		// Jax:           jaxClient,
		// Mako:          makoCLient,
		// Names:         namesClient,
		// Panels:        panels,
		// Passport:      passport,
		// Payday:        paydayClient,
		// Permissions: permissions,
		// Ripley:        ripleyClient,
		// Tracking:      trackingClient,
		// Subscriptions: subscriptionsClient,
		// Users:         users,
		// Vod:           vodClient,
	}, nil
}
