package gql

import (
	"fmt"
	"time"
)

// Duration represents the a defined time duration compatible with go time package.
type Duration struct {
	time.Duration
}

// ImplementsGraphQLType informs github.com/graph-gophers/graphql-go the Duration type
// implements the custom scalar `Cursor`.
func (*Duration) ImplementsGraphQLType(name string) bool {
	return name == "Duration"
}

// UnmarshalGraphQL describes how to unmarshal GraphQL input into a Duration type.
// Required by the github.com/graph-gophers/graphql-go library.
func (d *Duration) UnmarshalGraphQL(input interface{}) error {
	switch input := input.(type) {
	case string:
		var err error
		duration, err := time.ParseDuration(input)
		d.Duration = duration
		return err
	case int:
		d.Duration = time.Duration(input)
		return nil
	case float64:
		d.Duration = time.Duration(int64(input))
		return nil
	default:
		return fmt.Errorf("wrong type for duration")
	}
}
