package gql

// PageInfo is used in pagination queries to indicate to the client
// if there are more pages before or after the current page
type PageInfo struct {
	Next     bool
	Previous bool
}

// HasNextPage returns true if there are more items after the last cursor
// returned
func (r PageInfo) HasNextPage() bool {
	return r.Next
}

// HasPreviousPage returns true if the page request didn't start from the beginning
func (r PageInfo) HasPreviousPage() bool {
	return r.Previous
}
