package query

import (
	"context"
	"errors"
	"strconv"

	"code.justin.tv/safety/aegis/internal/auth"
	"code.justin.tv/safety/aegis/internal/ctxkeys"
	"code.justin.tv/safety/datastore/models"

	graphql "github.com/graph-gophers/graphql-go"
)

// Me is a resolver for information about the currently logged in user
type Me struct {
	userInfo *auth.UserInfo
	admin    *models.Admin
}

// NewMeResolver creates a resolver for information about the currently logged in user
func NewMeResolver(ctx context.Context) (*Me, error) {
	admin, ok := ctx.Value(ctxkeys.MyUser).(*models.Admin)
	if !ok {
		return nil, errors.New("unable to find my user in the context")
	}

	userInfo, ok := ctx.Value(ctxkeys.MyUserInfo).(*auth.UserInfo)
	if !ok {
		return nil, errors.New("unable to find my user info in the context")
	}

	return &Me{
		admin:    admin,
		userInfo: userInfo,
	}, nil
}

// ID resolves to the obfuscated ID of the google account
func (r *Me) ID() graphql.ID {
	return graphql.ID(strconv.FormatInt(r.admin.ID, 10))
}

// FullName resolves to the full name of the admin
func (r *Me) FullName() string {
	return r.userInfo.FullName
}

// Admin resolves to an Admin resolver for the logged in user
// func (r *Me) Admin(ctx context.Context) (*Admin, error) {
// return NewAdminResolver(ctx, r.admin.ID)
// }
