package images

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestExtensionByType(t *testing.T) {
	testCases := []struct {
		ext  string
		mime string
	}{
		{
			ext:  ".jpg",
			mime: "image/jpeg",
		},
		{
			ext:  ".png",
			mime: "image/png",
		},
	}

	for _, testCase := range testCases {
		ext, err := ExtensionByType(testCase.mime)
		assert.NoError(t, err)
		assert.Equal(t, testCase.ext, ext)
	}
}

func TestExtensionByTypeError(t *testing.T) {
	ext, err := ExtensionByType("random_mime")
	assert.Error(t, err)
	assert.Empty(t, ext)

	ext, err = ExtensionByType("image/gif")
	assert.Error(t, err)
	assert.Empty(t, ext)
}
