package interfaces

import (
	"context"

	graphql "github.com/graph-gophers/graphql-go"
	"github.com/graph-gophers/graphql-go/errors"
)

// Schema is an interface to the operations that github.com/graph-gophers/graphql-go's Schema type
// implements to allow mocking
type Schema interface {
	Validate(queryString string) []*errors.QueryError
	Exec(ctx context.Context, queryString string, operationName string, variables map[string]interface{}) *graphql.Response
}
