package locales

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"golang.org/x/text/language"
)

func TestUniqueDisplayValue(t *testing.T) {
	displays := map[string]struct{}{}
	for _, display := range Locales {
		if _, ok := displays[display]; ok {
			assert.Fail(t, "", "Display value %s already exist", display)
		}
	}
}

func TestLanguageCodeAreValid(t *testing.T) {
	for code := range Locales {
		_, err := language.Parse(code)
		assert.NoError(t, err, "Parsing language code %v", code)
	}
}
