package permissions

//Permission models a beefcake permission
type Permission string

// List of beefcake permissions
// "legacy:" is prepended to the permissions that we check from beefcake as beefcake v2 returns these permissions with "legacy:" as part of the Id.
// When requesting a permissions we don't append legacy, therefore legacyReportReadPermission does not have legacy prepended to it
// To remove this in the future, we need to move to using roles in beefcake instead of these legacy permissions.
const (
	legacyReportReadPermission = "aegis_report_read"
	ReportRead                 = "legacy:aegis_report_read"
	ReportWrite                = "legacy:aegis_report_write"
	SupportTools               = "legacy:support_tools"
	SuspensionRead             = "legacy:aegis_suspension_read"
)
