package permissions

import (
	"strings"
)

// Config contains the configuration parameters required to create
// an instance of the Permissions object
type Config struct {
	BeefcakeEndpoint string
}

// validate validates the config. It returns an error if the config is invalid
func (c Config) validate() error {
	if len(strings.TrimSpace(c.BeefcakeEndpoint)) == 0 {
		return ErrBeefcakeEndpointRequired
	}
	return nil
}
