package permissions

import (
	"context"
)

type userPermissionFake struct {
	value bool
}

func (u userPermissionFake) IsPermitted(_ string) bool {
	return u.value
}

// WithAlwaysAllowPermission returns a new context with permissions that allows everything
func WithAlwaysAllowPermission(ctx context.Context) context.Context {

	return context.WithValue(ctx, MyPermissions, userPermissionFake{value: true})
}

// WithAlwaysDisallowPermission returns a new context with permissions that disallows everything
func WithAlwaysDisallowPermission(ctx context.Context) context.Context {

	return context.WithValue(ctx, MyPermissions, userPermissionFake{value: false})
}
