package permissions

import (
	"context"
	"testing"

	beefcake "code.justin.tv/amzn/TwitchBeefcakeTwirp"
	mocks "code.justin.tv/safety/aegis/internal/clients/mocks/beefcake"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestNew(t *testing.T) {
	c := Config{}
	c.BeefcakeEndpoint = "endpoint"
	fake := &mocks.FakeTwitchBeefcake{}

	client, err := New(fake)
	assert.NoError(t, err)
	assert.NotNil(t, client)
}

func TestPermissions(t *testing.T) {
	const ldapUserUID = "my-test-uid"
	t.Run("UsersWithReportAccess", func(t *testing.T) {
		t.Run("success", func(t *testing.T) {
			fake := &mocks.FakeTwitchBeefcake{}
			fake.GetLegacyPermissionReturns(&beefcake.LegacyPermission{
				Users: []*beefcake.LegacyPermission_User{
					&beefcake.LegacyPermission_User{
						Id: ldapUserUID,
					},
				},
			}, nil)

			p := &Permissions{beefcakeClient: fake}
			users, err := p.UsersWithReportAccess(context.Background())
			require.NoError(t, err)
			assert.Equal(t, []string{ldapUserUID}, users)

		})
	})
}
