package permissions

import (
	"context"
	"testing"

	"github.com/pkg/errors"
	"github.com/stretchr/testify/assert"
)

func TestUserCanReadSuspension(t *testing.T) {
	testCases := []struct {
		permissions UserPermissions
		canRead     bool
	}{
		{
			permissions: AllowNone(),
			canRead:     false,
		},
		{
			permissions: AllowFor(SuspensionRead),
			canRead:     true,
		},
	}

	for _, testCase := range testCases {
		ctx := context.WithValue(context.Background(), MyPermissions, testCase.permissions)

		perm, err := CanReadSuspension(ctx)
		assert.NoError(t, err)
		assert.Equal(t, testCase.canRead, perm)
	}
}

func TestUserCanReadSuspensionErrors(t *testing.T) {
	ctx := context.Background()
	perm, err := CanReadSuspension(ctx)
	assert.Equal(t, ErrPermissionsMissing, errors.Cause(err))
	assert.False(t, perm)
}

func TestUserCanIssueSuspension(t *testing.T) {
	testCases := []struct {
		permissions UserPermissions
		canRead     bool
	}{
		{
			permissions: AllowNone(),
			canRead:     false,
		},
		{
			permissions: AllowFor(SupportTools),
			canRead:     true,
		},
	}

	for _, testCase := range testCases {
		ctx := context.WithValue(context.Background(), MyPermissions, testCase.permissions)

		perm, err := CanIssueSuspension(ctx)
		assert.NoError(t, err)
		assert.Equal(t, testCase.canRead, perm)
	}
}

func TestUserCanIssueSuspensionErrors(t *testing.T) {
	ctx := context.Background()
	perm, err := CanIssueSuspension(ctx)
	assert.Equal(t, ErrPermissionsMissing, errors.Cause(err))
	assert.False(t, perm)
}
